/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.util.JavaVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticaDefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable,
UIResource {
    private static final long serialVersionUID = 9059722839161202006L;
    private Border noFocusBorder;
    private Border focusBorder;
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private Color alternateColor;
    private boolean colorCachingEnabled;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public SyntheticaDefaultTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.setOpaque(true);
        Border border = tableCellRenderer == null ? new EmptyBorder(0, 0, 0, 0) : ((JComponent)((Object)tableCellRenderer)).getBorder();
        Insets insets = border == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(null);
        Border border2 = UIManager.getBorder("Table.focusCellHighlightBorder");
        Border border3 = border2 == null ? new EmptyBorder(0, 0, 0, 0) : border2;
        Insets insets2 = border3.getBorderInsets(null);
        Insets insets3 = new Insets(insets.top - insets2.top, insets.left - insets2.left, insets.bottom - insets2.bottom, insets.right - insets2.right);
        this.focusBorder = new CompoundBorder(border3, new EmptyBorder(insets3));
        this.noFocusBorder = new CompoundBorder(new EmptyBorder(insets2), new EmptyBorder(insets3));
        this.alternateColor = UIManager.getColor("Table.alternateRowColor");
        this.colorCachingEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.table.cellRenderer.colorCache.enabled", null, false);
    }

    @Override
    public String getName() {
        String string = super.getName();
        if (string == null) {
            string = "Table.cellRenderer";
        }
        return string;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.colorCachingEnabled) {
            this.unselectedForeground = color;
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.colorCachingEnabled) {
            this.unselectedBackground = color;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTable.DropLocation dropLocation;
        Color color = null;
        Color color2 = null;
        if (!(JavaVersion.JAVA5 || (dropLocation = jTable.getDropLocation()) == null || dropLocation.isInsertRow() || dropLocation.isInsertColumn() || dropLocation.getRow() != n || dropLocation.getColumn() != n2)) {
            color = UIManager.getColor("Table.dropCellForeground");
            color2 = UIManager.getColor("Table.dropCellBackground");
            bl = true;
        }
        if (bl) {
            if (color == null) {
                color = jTable.getSelectionForeground();
            }
            if (color2 == null) {
                color2 = jTable.getSelectionBackground();
            }
        } else {
            color = this.unselectedForeground == null ? jTable.getForeground() : this.unselectedForeground;
            Color color3 = color2 = this.unselectedBackground == null ? jTable.getBackground() : this.unselectedBackground;
            if ((color2 == null || color2 instanceof UIResource) && this.alternateColor != null && n % 2 == (JavaVersion.JAVA7_OR_ABOVE ? 1 : 0)) {
                color2 = this.alternateColor;
            }
            if (bl2 && jTable.isCellEditable(n, n2)) {
                color = UIManager.get("Table.focusCellForeground") == null ? color : UIManager.getColor("Table.focusCellForeground");
                color2 = UIManager.get("Table.focusCellBackground") == null ? color2 : UIManager.getColor("Table.focusCellBackground");
            }
        }
        super.setForeground(color);
        super.setBackground(color2);
        if (bl2) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
        this.setFont(jTable.getFont());
        this.setValue(object);
        this.setIcon(null);
        this.configureValue(object, jTable.getColumnClass(n2));
        return this;
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    private void configureValue(Object object, Class<?> clazz) {
        if (clazz == Object.class || clazz == null) {
            this.setHorizontalAlignment(10);
        } else if (clazz == Float.class || clazz == Double.class) {
            if (this.numberFormat == null) {
                this.numberFormat = NumberFormat.getInstance();
            }
            this.setHorizontalAlignment(11);
            this.setText(object == null ? "" : this.numberFormat.format(object));
        } else if (clazz == Number.class) {
            this.setHorizontalAlignment(11);
        } else if (clazz == Date.class) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance();
            }
            this.setHorizontalAlignment(10);
            this.setText(object == null ? "" : this.dateFormat.format(object));
        } else if (clazz == Icon.class || clazz == ImageIcon.class) {
            this.setHorizontalAlignment(0);
            this.setIcon(object instanceof Icon ? (Icon)object : null);
            this.setText("");
        } else {
            this.configureValue(object, clazz.getSuperclass());
        }
    }

    @Override
    public boolean isOpaque() {
        boolean bl;
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl2 = bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text" || string == "labelFor" || string == "displayedMnemonic" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

